/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.KeyItemSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.PokemonSpeciesSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import com.github.d0ctorleon.mythsandlegends.permissions.MythsAndLegendsPermissions;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PersistentDataUtil;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class Commands {
    private static final MythsAndLegendsPermissions PERMISSIONS = new MythsAndLegendsPermissions();

    public static boolean hasPermission(class_2168 source, CobblemonPermission permission) {
        return MythsAndLegendsPermissions.checkPermission((class_2172)source, permission);
    }

    public static void registerCommands() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> Commands.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        MythsAndLegends.getLogger().debug("Start registering commands");
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mythsandlegends").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listitems").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_ITEMS_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(Commands::listItems)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"checkinventory").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_INVENTORY_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(Commands::checkInventory)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"applyaspectsandforms").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.APPLY_ASPECTS_AND_FORMS))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(Commands::applyAspectsAndForms)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listpokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_POKEMON_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(Commands::listPokemons)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"checkpokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_POKEMON_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"pokemon", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).executes(Commands::checkForPokemon))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setblockcheckspecies").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.SET_BLOCK_CHECK_SPECIES_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(Commands::setblockcheckspecies))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).executes(Commands::openSettingsGui)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"forcespawn").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.FORCE_SPAWN_PERMISSION))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"keyitem", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::forceSpawn))))));
        MythsAndLegends.getLogger().info("Registered Myths and Legends commands");
    }

    private static int listItems(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        PlayerDataUtils.PlayerData playerData = PlayerDataUtils.getPlayerData((class_1657)player);
        String itemsWithCounts = playerData.getFormattedItemsWithCounts();
        source.method_9226(() -> class_2561.method_43469((String)"command.myths_and_legends.items_in_inventory", (Object[])new Object[]{playerName, itemsWithCounts}), false);
        return 1;
    }

    private static int checkInventory(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
        source.method_9226(() -> class_2561.method_43469((String)"command.myths_and_legends.inventory_checked", (Object[])new Object[]{playerName}), false);
        return 1;
    }

    private static int listPokemons(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        List<Pokemon> pokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        if (pokemons.isEmpty()) {
            source.method_9226(() -> class_2561.method_43469((String)"command.myths_and_legends.no_pokemon", (Object[])new Object[]{playerName}), false);
        } else {
            String pokemonList = pokemons.stream().map(pokemon -> String.format("%s (%s, Showdown ID: %s)", pokemon.getDisplayName().getString(), pokemon.getSpecies().getName(), pokemon.getSpecies().showdownId())).collect(Collectors.joining(", "));
            source.method_9226(() -> class_2561.method_43469((String)"command.myths_and_legends.pokemon_list", (Object[])new Object[]{playerName, pokemonList}), false);
        }
        return 1;
    }

    private static int checkForPokemon(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon");
        if (!Commands.isValidSpecies(speciesNameToCheck)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"command.myths_and_legends.invalid_species", (Object[])new Object[]{speciesNameToCheck}));
            return 0;
        }
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        for (Pokemon partyPokemon : partyPokemons) {
            if (!partyPokemon.getSpecies().getName().equalsIgnoreCase(speciesNameToCheck)) continue;
            source.method_9226(() -> class_2561.method_43469((String)"commands.myths_and_legends.has_pokemon", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43469((String)"commands.myths_and_legends.not_have_pokemon", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        return 1;
    }

    private static int setblockcheckspecies(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String speciesName = StringArgumentType.getString(context, (String)"species");
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2247 block = class_2257.method_9655(context, (String)"block");
        if (!Commands.isValidSpecies(speciesName)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"command.myths_and_legends.invalid_species", (Object[])new Object[]{speciesName}));
            return 0;
        }
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        if (!Commands.hasPokemon(targetPlayer, speciesName)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.myths_and_legends.setblockcheckspecies.does_not_have_pokemon", (Object[])new Object[]{playerName, speciesName}));
            return 0;
        }
        class_3218 world = source.method_9225();
        if (!block.method_9495(world, pos, 2)) {
            Narrator.LOGGER.error("Failed to set block at {}", (Object)pos);
        }
        world.method_8408(pos, block.method_9494().method_26204());
        source.method_9226(() -> class_2561.method_43469((String)"commands.myths_and_legends.setblockcheckspecies.success", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), true);
        return 1;
    }

    private static int forceSpawn(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        String keyItemIdentifierPath = StringArgumentType.getString(context, (String)"keyitem");
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        boolean result = ForceSpawningUtils.forceSpawnv1command((class_1657)player, keyItemIdentifierPath);
        if (result) {
            source.method_9226(() -> class_2561.method_43469((String)"command.myths_and_legends.forcespawn.success", (Object[])new Object[]{playerName, keyItemIdentifierPath}), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43469((String)"command.myths_and_legends.forcespawn.failure", (Object[])new Object[]{playerName, keyItemIdentifierPath}));
        return 0;
    }

    private static boolean isValidSpecies(String speciesName) {
        Collection allSpecies = PokemonSpecies.INSTANCE.getSpecies();
        return allSpecies.stream().anyMatch(species -> species.getName().equalsIgnoreCase(speciesName));
    }

    private static boolean hasPokemon(class_3222 player, String speciesName) {
        List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        return partyPokemons.stream().anyMatch(pokemon -> pokemon.getSpecies().getName().equalsIgnoreCase(speciesName));
    }

    private static int openSettingsGui(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.myths_and_legends.player_not_found"));
            return 0;
        }
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        ConfigGui configGui = new ConfigGui();
        configGui.openConfigGui(player, config);
        source.method_9226(() -> class_2561.method_43471((String)"command.myths_and_legends.settings_gui_opened"), true);
        return 1;
    }

    private static int applyAspectsAndForms(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player.method_37908().field_9236) {
            MythsAndLegends.getLogger().warn("onPlayerJoin called on client side! This should not happen.");
            return 0;
        }
        MythsAndLegends.getLogger().debug("Processing party data for player: " + player.method_5477().getString());
        Cobblemon.INSTANCE.getStorage().getParty(player).forEach(PersistentDataUtil::applyPersistentDataToPokemon);
        Cobblemon.INSTANCE.getStorage().getPC(player).forEach(PersistentDataUtil::applyPersistentDataToPokemon);
        MythsAndLegends.getLogger().debug("PC data processed successfully for player: " + player.method_5477().getString());
        return 1;
    }
}

